function [] = showCut(pos, cutPos, cutPlane, color)

% Function for showing the discretization of the scatterers dividing the
% space into to halves. Only dipoles on the left of a given plane will be
% shown

%%%%%% INPUT ARGUMENTS %%%%%%
%%% pos:      position of the dipoles                      %%%
%%% cutPos:   position of the cutting plane                %%%
%%% cutPlane: type of cut (xz,yz or xy)                    %%%
%%% color:    color for the dipole representation          %%%



% loop length %
N = length(pos(:,1));


% Discarding one half of the space %
k = 0;
for i = 1:N
    if(cutPlane == "yz" && pos(i-k,1) <= cutPos)

        pos(i-k,:) = [];
        k = k+1;

    elseif(cutPlane == "xz" && pos(i-k,2) <= cutPos)

        pos(i-k,:) = [];
        k = k+1;

    elseif(cutPlane == "xy" && pos(i-k,3) <= cutPos)

        pos(i-k,:) = [];
        k = k+1;

    end

end

% Showing resulting cutted distribution %
figure(1)
hold on
axis equal
scatter3(pos(:,1),pos(:,2),pos(:,3),'SizeData',12,'MarkerEdgeColor',...
            color,'MarkerFaceColor',color);

end